<?php

// Make sure SimplePie is included. You may need to change this to match the location of simplepie.inc.
include ('/home/proreform/www/kaitai/rssparse/simplepie/simplepie.inc');

$feed_array = array(
    'news'    => 'http://kai-tai.blogspot.com/feeds/posts/default?alt=rss',
);
$feed_url = (array_key_exists($_GET['feed'], $feed_array)) ? $feed_array[$_GET['feed']] : $feed_array['index'];
$num = is_numeric($_GET['num']) ? $_GET['num'] : 20;

// We'll process this feed with all of the default options.
$feed = new SimplePie();
$feed->set_output_encoding("Shift-JIS");
$feed->set_feed_url($feed_url);
$feed->set_cache_location($_SERVER['DOCUMENT_ROOT'].'/rssparse/cache');
$feed->init();

// This makes sure that the content is sent to the browser as text/html and the UTF-8 character set (since we didn't change it).
$feed->handle_content_type();

/*
 * Here, we'll loop through all of the items in the feed, and $item represents the current item in the loop.
 */
$items_array = $feed->get_items();
echo ('<ul>');
if (count($items_array) > 0) {
    for ($i=0; $i < $num && $i < count($items_array); $i++) {
        $item = $items_array[$i];
        echo ('<li><span class="styleSpan01"><span class="columnLeft"><span>'.$item->get_date('Y/m/d').'</span></span>');
        echo ('<span class="columnRight"><a href="'.$item->get_permalink().'" target="_blank">'.$item->get_title().'</a></span></span></li>');
    }

} else {
    echo ('<li>݂͂܂B</li>');
}
echo ('</ul>');
?>
